/**
 * Copyright (C) 2012, BMW AG
 *
 * This file is part of GENIVI Project AudioManager.
 *
 * Contributions are licensed to the GENIVI Alliance under one or more
 * Contribution License Agreements.
 *
 * \copyright
 * This Source Code Form is subject to the terms of the
 * Mozilla Public License, v. 2.0. If a  copy of the MPL was not distributed with
 * this file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *
 * \author Christian Mueller, christian.linke@bmw.de BMW 2011,2012
 *
 * \file
 * For further information see http://www.genivi.org/.
 *
 * THIS CODE HAS BEEN GENERATED BY ENTERPRISE ARCHITECT GENIVI MODEL. PLEASE CHANGE ONLY IN ENTERPRISE ARCHITECT AND GENERATE AGAIN
 */
#if !defined(EA_793BA955_1445_4da2_9C22_4EFA92A026C5__INCLUDED_)
#define EA_793BA955_1445_4da2_9C22_4EFA92A026C5__INCLUDED_

namespace am {
  /**
   * This enum classifies the format in which data is exchanged within a connection. The enum itself is project specific
   * although there are some Genivi standard formats defined.
   * @author Christian Mueller
   * @created 16-Dez-2012 15:58:14
   */
  enum am_ConnectionFormat_e
  {
    /**
     * default
     */
    CF_UNKNOWN = 0,
    /**
     * plain mono
     */
    CF_MONO = 1,
    /**
     * stereo connection
     */
    CF_STEREO = 2,
    CF_MAX
  };

  /**
   * This enum gives the information about reason for reason for Source/Sink change
   * @author Christian Mueller
   * @created 16-Dez-2012 15:58:14
   */
  enum am_AvailabilityReason_e
  {
    /**
     * default
     */
    AR_UNKNOWN = 0,
    /**
     * the availability changed because an new media was entered
     */
    AR_GENIVI_NEWMEDIA = 1,
    /**
     * the availability changed because the same media was entered
     */
    AR_GENIVI_SAMEMEDIA = 2,
    /**
     * the availability changed because there is no media
     */
    AR_GENIVI_NOMEDIA = 3,
    /**
     * the availability changed because of a temperature event
     */
    AR_GENIVI_TEMPERATURE = 4,
    /**
     * the availability changed because of a voltage event
     */
    AR_GENIVI_VOLTAGE = 5,
    /**
     * the availability changed because of fatal errors reading or accessing media
     */
    AR_GENIVI_ERRORMEDIA = 6,
    AR_MAX
  };

  /**
   * product specific identifier of property
   * @author Christian Mueller
   * @created 16-Dez-2012 15:58:14
   */
  enum am_ClassProperty_e
  {
    /**
     * default
     */
    CP_UNKNOWN = 0,
    /**
     * defines the source type of a source. Project specific, could be for example differentiation between interrupt source
     * and main source.
     */
    CP_GENIVI_SOURCE_TYPE = 1,
    /**
     * defines the SINK_TYPE. Project specific
     */
    CP_GENIVI_SINK_TYPE = 2,
    CP_MAX
  };

  /**
   * The given ramp types here are just a possiblity. for products, different ramp types can be defined here.
   * It is in the responsibility of the product to make sure that the routing plugins are aware of the ramp types used.
   * @author Christian Mueller
   * @created 16-Dez-2012 15:58:14
   */
  enum am_RampType_e
  {
    RAMP_UNKNOWN = 0,
    RAMP_MAX
  };

  /**
   * sound properties. Within genivi only the standard properties are defined, for products these need to be extended.
   * @author Christian Mueller
   * @created 16-Dez-2012 15:58:14
   */
  enum am_SoundPropertyType_e
  {
    /**
     * default
     */
     SP_UNKNOWN = 0,
     SP_SOUND_BASS = 1,
     SP_SOUND_MIDDLE = 3,
     SP_SOUND_TREBLE = 5,
     SP_MAX
  };

  /**
   * Here are all SoundProperties that can be set via the CommandInterface. Product specific
   * @author Christian Mueller
   * @created 16-Dez-2012 15:58:14
   */
  enum am_MainSoundPropertyType_e
  {
    /**************************************************************************
     * default
     */
    MSP_UNKNOWN = 0,
    /**
     * Bass setting to absolute value
     */
    MSP_SOUND_BASS = 1,
    /**
     * Bass setting with relative steps. Modifies property MSP_SOUND_BASS
     */
    MSP_SOUND_BASS_RELATIVE = 2,
    /**
     * Middle setting to absolute value
     */
    MSP_SOUND_MIDDLE = 3,
    /**
     * Middle setting with relative steps. Modifies property MSP_SOUND_MIDDLE
     */
    MSP_SOUND_MIDDLE_RELATIVE = 4,
    /**
     * Treble setting to absolute value
     */
    MSP_SOUND_TREBLE = 5,
    /**
    /**
     * Treble setting with relative steps. Modifies property MSP_SOUND_TREBLE
     */
    MSP_SOUND_TREBLE_RELATIVE = 6,
    /**
     * Loudness setting to absolute value
     */
    MSP_SOUND_LOUDNESS = 7,
    /**
     * Loudness setting with relative steps. Modifies property MSP_SOUND_LOUDNESS
     */
    MSP_SOUND_LOUDNESS_RELATIVE = 8,
    /**
     * Balance setting to absolute value
     */
    MSP_SOUND_BALANCE = 9,
    /**
     * Balance setting with relative steps. Modifies property MSP_SOUND_BALANCE
     */
    MSP_SOUND_BALANCE_RELATIVE = 10,
    /**
     * Fader setting to absolute value
     */
    MSP_SOUND_FADER = 11,
    /**
     * Fader setting with relative steps. Modifies property MSP_SOUND_FADER
     */
    MSP_SOUND_FADER_RELATIVE = 12,
    /**
     * Dynamic compression. Possible values defined as AM_MSP_DYN_COMPRESSION_*
     */
    MSP_SOUND_DYN_COMPRESSION = 13,
    /**
     * Equalizer Presets. Possible values defined as AM_MSP_EQU_PRESET_*
     */
    MSP_EQUALIZER_PRESET = 14,
    /**
     * Speed dependent volume: Possible values defined as AM_MSP_SDV_*
     */
    MSP_SPEED_DEPENDENT_VOLUME = 15,
    /**
     * Microphone connection status. Possible values defined as
     */
    MSP_MIC_STATUS_CONNECTION = 16,
    /**
     * Microphone level. Possible values defined as
     */
    MSP_MIC_STATUS_LEVEL = 17,
    /**
     * Sound optimization. Possible values defined as AM_MSP_SND_OPTI_*
     */
    MSP_SOUND_OPTIMIZATION = 18,
    /**
     * Room effect. Possible values defined as
     */
    MSP_SOUND_ROOM_EFFECT = 19,
    /**
     * Aux In level. Possible values defined as AM_MSP_LVL_AUX_IN_*
     */
    MSP_LEVEL_AUX_IN = 20,
    /**
     * Beep level. Possible values defined as
     */
    MSP_LEVEL_BEEP = 21,
    /**
     * Center speaker level. Possible values defined as
     */
    MSP_LEVEL_CENTER = 22,
    /**
     * Subwoofer level. Possible values defined as
     */
    MSP_LEVEL_SUBWOOFER = 23,
    /**
     * Surround Setting. Possible values defined as
     */
    MSP_SETTING_SURROUND = 24,
    /**
     * Audio Mode
     */
    MSP_MODE_AUDIO = 25,
  /**
     * Volume for entertainment sources
     */
  MSP_VOLUME_ENTERTAINMENT = 26,
  /**
     * Volume for Phone source
     */
  MSP_VOLUME_PHONE = 27,
  /**
     * Volume for ONVOL
     */
  MSP_VOLUME_ONVOL = 28,
  /**
     * Volume for TA sources
     */
  MSP_VOLUME_TA = 29,
  /**
     * Volume for Beep tone
     */
  MSP_VOLUME_BEEP = 30,
  /**
     * PDC Attenuation level. Possible values defined as AM_MSP_PDC_ATTENUATION_*
     */
  MSP_PDC_ATTENUATION_LEVEL = 31,
    /**
     * BTAudio In level. Possible values defined as AM_MSP_LVL_BTAUDIO_IN_*
     */
  MSP_LEVEL_BTAUDIO_IN = 32,
    /**
     * Gala Gain status.
     */
  MSP_GALA_GAIN = 33,
    /**
     * PDC status. Possible values defined as AM_MSP_PDC_COMMAND_*
     */
  MSP_PDC_ACTIVE = 34,
    /**
     * Volume lock status.
     */
  MSP_VOLUME_LOCK = 35,
    /**
     * System Mute status.
     */
  MSP_SYSTEM_MUTE = 36,
    MSP_MAX
  };

  /**
   * describes the different system properties. Project specific
   * @author Christian Mueller
   * @created 16-Dez-2012 15:58:14
   */
  enum am_SystemPropertyType_e
  {
    /**
     * default
     */
    SYP_UNKNOWN = 0,
    /**
     * Beep. Different beeps can be started with this
     */
    SYP_BEEP = 1,
    /**
     * Fader status active
     */
    SYP_FADER_STATUS_ACTIVE = 2,
    /**
     * Volume mode for main1 stream
     */
    SYP_VOLMODE_STREAM_MAIN_1 = 3,
    /**
     * Volume mode for Mix1 stream
     */
    SYP_VOLMODE_STREAM_MIX_1 = 4,
    /**
     * Diagnosis remote control
     */
  SYP_DIAG_REMOTE_CONTROL = 5,

    SYP_MAX
  };

  /**
   * gives the type of the Notification.
   * @author q232968
   * @version 1.0
   * @created 16-Dez-2012 15:58:14
   */
  enum am_NotificationType_e
  {
    NT_UNKNOWN = 0,
    NT_MAX
  };

/**
* product specific defines for property values
* @author Stefan Knopp
* @created 28-Aug-2013 14:00:00
*/

    /**
     * MSP_SOUND_DYN_COMPRESSION values
     */
    #define AM_MSP_DYN_COMPRESSION_OFF  ((int16_t) 0)
    #define AM_MSP_DYN_COMPRESSION_ON   ((int16_t) 1)


    /**
     * MSP_EQUALIZER_PRESET values
     */
    #define AM_MSP_EQU_PRESET_NEUTRAL  ((int16_t) 0)
    #define AM_MSP_EQU_PRESET_ROCK     ((int16_t) 1)
    #define AM_MSP_EQU_PRESET_POP      ((int16_t) 2)
    #define AM_MSP_EQU_PRESET_CLASSIC  ((int16_t) 3)
    #define AM_MSP_EQU_PRESET_VOICE    ((int16_t) 4)


    /**
     * MSP_SPEED_DEPENDENT_VOLUME values
     */
    #define AM_MSP_SDV_OFF      ((int16_t) 0)
    #define AM_MSP_SDV_LEVEL_1  ((int16_t) 1)
    #define AM_MSP_SDV_LEVEL_2  ((int16_t) 2)
    #define AM_MSP_SDV_LEVEL_3  ((int16_t) 3)
    #define AM_MSP_SDV_LEVEL_4  ((int16_t) 4)
    #define AM_MSP_SDV_LEVEL_5  ((int16_t) 5)
  #define AM_MSP_SDV_LEVEL_6  ((int16_t) 6)
  #define AM_MSP_SDV_LEVEL_7  ((int16_t) 7)


    /**
     * MSP_MIC_STATUS_CONNECTION values
     */
    /* Values yet to be defined */


    /**
     * MSP_MIC_STATUS_LEVEL values
     */
    /* Values yet to be defined */


    /**
     * MSP_SOUND_OPTIMIZATION values
     */
    #define AM_MSP_SND_OPTI_OFF      ((int16_t) 0)
    #define AM_MSP_SND_OPTI_LEFT     ((int16_t) 1)
    #define AM_MSP_SND_OPTI_RIGHT    ((int16_t) 2)
    #define AM_MSP_SND_OPTI_ALL      ((int16_t) 3)
    #define AM_MSP_SND_OPTI_DRIVER   ((int16_t) 4)
    #define AM_MSP_SND_OPTI_FRONT    ((int16_t) 5)


    /**
     * MSP_SOUND_ROOM_EFFECT values
     */
    /* Values yet to be defined */


    /**
     * MSP_LEVEL_AUX_IN values
     */
    #define AM_MSP_LVL_AUX_IN_LEVEL1      ((int16_t) 1)
    #define AM_MSP_LVL_AUX_IN_LEVEL2      ((int16_t) 2)
    #define AM_MSP_LVL_AUX_IN_LEVEL3      ((int16_t) 3)


    /**
     * MSP_LEVEL_BEEP values
     */
    /* Values yet to be defined */


    /**
     * MSP_LEVEL_CENTER values
     */
    /* Values yet to be defined */


    /**
     * MSP_LEVEL_SUBWOOFER values
     */


     /**
     * MSP_SETTING_SURROUND values
     */
    /* Values yet to be defined */


    /**
     * MSP_MODE_AUDIO values
     */
    #define AM_MSP_MODE_AUDIO_NORMAL      ((int16_t) 0)
    #define AM_MSP_MODE_AUDIO_LINEAR      ((int16_t) 1)

  /**
     * MSP_PDC_ATTENUATION_LEVEL values
     */
  #define AM_MSP_PDC_ATTENUATION_OFF       ((int16_t) 0)
  #define AM_MSP_PDC_ATTENUATION_LIGHTER   ((int16_t) 1)
  #define AM_MSP_PDC_ATTENUATION_LIGHT     ((int16_t) 2)
  #define AM_MSP_PDC_ATTENUATION_MEDIUM    ((int16_t) 3)
  #define AM_MSP_PDC_ATTENUATION_STRONG    ((int16_t) 4)
  #define AM_MSP_PDC_ATTENUATION_STRONGER  ((int16_t) 5)
  #define AM_MSP_PDC_ATTENUATION_MAX       ((int16_t) 6)

    /**
     * MSP_LEVEL_BTAUDIO_IN values
     */
  #define AM_MSP_LVL_BTAUDIO_IN_LEVEL1   ((int16_t) 1)
  #define AM_MSP_LVL_BTAUDIO_IN_LEVEL2   ((int16_t) 2)
  #define AM_MSP_LVL_BTAUDIO_IN_LEVEL3   ((int16_t) 3)

    /**
     * MSP_PDC_ACTIVE values
     */
  #define AM_MSP_PDC_COMMAND_START   ((int16_t) 1)
  #define AM_MSP_PDC_COMMAND_STOP    ((int16_t) 2)
  #define AM_MSP_PDC_COMMAND_BREAK   ((int16_t) 3)

    /**
     * SYP_BEEP values
     */
    #define AM_SYP_BEEP_ERROR  ((int16_t) 1)
    #define AM_SYP_BEEP_ROGER  ((int16_t) 2)
    #define AM_SYP_BEEP_WARN   ((int16_t) 3)
    #define AM_SYP_BEEP_CLICK  ((int16_t) 4)


    /**
     * SYP_FADER_STATUS_ACTIVE values
     */
    #define AM_SYP_FADER_STATUS_INACTIVE  ((int16_t) 0)
    #define AM_SYP_FADER_STATUS_ACTIVE    ((int16_t) 1)


    /**
     * SYP_VOLMODE_STREAM_MAIN_1 values
     * and
     * SYP_VOLMODE_STREAM_MIX_1 values
     */
    #define AM_SYP_VOLMODE_NORMAL                      ((int16_t) 0)
    #define AM_SYP_VOLMODE_SETUP_ONVOL                 ((int16_t) 1)
    #define AM_SYP_VOLMODE_SETUP_PHONE                 ((int16_t) 2)
    #define AM_SYP_VOLMODE_SETUP_TIM                   ((int16_t) 3)
    #define AM_SYP_VOLMODE_SETUP_TA                    ((int16_t) 4)
    #define AM_SYP_VOLMODE_BEEPVOL                     ((int16_t) 5)
    #define AM_SYP_VOLMODE_DIAGVOL                     ((int16_t) 6)
    #define AM_SYP_VOLMODE_NAV_ANNOUNCEMENT            ((int16_t) 7)
    #define AM_SYP_VOLMODE_SETUP_NAV_VOL               ((int16_t) 8)
    #define AM_SYP_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL  ((int16_t) 9)
  #define AM_SYP_VOLMODE_PDC_ATTENUATION_SETUP       ((int16_t) 10)

}
#endif // !defined(EA_793BA955_1445_4da2_9C22_4EFA92A026C5__INCLUDED_)

